/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.world.explosion;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.mehvahdjukaar.supplementaries.block.blocks.BellowsBlock;
import net.mehvahdjukaar.supplementaries.block.util.ILightable;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.compat.decorativeblocks.DecoBlocksCompatRegistry;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.TNTBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class GunpowderExplosion
extends Explosion {
    private final World level;
    private final double x;
    private final double y;
    private final double z;
    private float radius;
    private final List<BlockPos> toBlow = new ArrayList<BlockPos>();

    public GunpowderExplosion(World world, Entity entity2, double x, double y, double z, float size) {
        super(world, entity2, null, null, x, y, z, size, false, Explosion.Mode.DESTROY);
        this.level = world;
        this.radius = size;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void func_77278_a() {
        int x = MathHelper.func_76128_c((double)this.x);
        int y = MathHelper.func_76128_c((double)this.y);
        int z = MathHelper.func_76128_c((double)this.z);
        this.radius *= 2.0f;
        ForgeEventFactory.onExplosionDetonate((World)this.level, (Explosion)this, new ArrayList(), (double)this.radius);
        this.explodeBlock(x + 1, y, z);
        this.explodeBlock(x - 1, y, z);
        this.explodeBlock(x, y + 1, z);
        this.explodeBlock(x, y - 1, z);
        this.explodeBlock(x, y, z + 1);
        this.explodeBlock(x, y, z - 1);
        BlockPos pos = new BlockPos(x, y, z);
        BlockState newFire = AbstractFireBlock.func_235326_a_((IBlockReader)this.level, (BlockPos)pos);
        if (this.hasFlammableNeighbours(pos) || this.level.func_180495_p(pos.func_177977_b()).isFireSource((IWorldReader)this.level, pos, Direction.UP) || newFire.func_177230_c() != Blocks.field_150480_ab) {
            this.level.func_175656_a(pos, newFire);
        }
    }

    private boolean hasFlammableNeighbours(BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockState state = this.level.func_180495_p(pos.func_177972_a(direction));
            if (!state.func_185904_a().func_76217_h() && (state.func_177230_c() != ModRegistry.BELLOWS.get() || (Integer)state.func_177229_b((Property)BellowsBlock.POWER) == 0 || state.func_177229_b((Property)BellowsBlock.FACING) != direction.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    public void explodeBlock(int i, int j, int k) {
        BlockPos pos = new BlockPos(i, j, k);
        FluidState fluidstate = this.level.func_204610_c(pos);
        if (fluidstate.func_206886_c() == Fluids.field_204541_a) {
            BlockState state = this.level.func_180495_p(pos);
            Block block2 = state.func_177230_c();
            if (block2.getExplosionResistance(state, (IBlockReader)this.level, pos, (Explosion)this) == 0.0f && !block2.isAir(state, (IBlockReader)this.level, pos) && block2 != Blocks.field_150480_ab && block2 instanceof TNTBlock) {
                this.toBlow.add(pos);
            }
            if (block2 instanceof ILightable) {
                ((ILightable)block2).lightUp(state, pos, (IWorld)this.level, ILightable.FireSound.FLAMING_ARROW);
            } else if (block2.func_203417_a((ITag)BlockTags.field_232882_ax_) && CampfireBlock.func_241470_h_((BlockState)state) || CompatHandler.deco_blocks && DecoBlocksCompatRegistry.canLightBrazier(state)) {
                this.level.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.TRUE), 11);
                ILightable.FireSound.FLAMING_ARROW.play((IWorld)this.level, pos);
            }
        }
    }

    public void func_77279_a(boolean flag) {
        ObjectArrayList drops = new ObjectArrayList();
        Collections.shuffle(this.toBlow, this.level.field_73012_v);
        for (BlockPos blockpos : this.toBlow) {
            BlockState blockstate = this.level.func_180495_p(blockpos);
            BlockPos immutable = blockpos.func_185334_h();
            this.level.func_217381_Z().func_76320_a("explosion_blocks");
            if (blockstate.canDropFromExplosion((IBlockReader)this.level, blockpos, (Explosion)this) && this.level instanceof ServerWorld) {
                TileEntity tileentity = blockstate.hasTileEntity() ? this.level.func_175625_s(blockpos) : null;
                LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.level).func_216023_a(this.level.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)blockpos)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)tileentity).func_216021_b(LootParameters.field_216281_a, null);
                builder.func_216015_a(LootParameters.field_216290_j, (Object)Float.valueOf(this.radius));
                blockstate.func_215693_a(builder).forEach(d -> this.addBlockDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)drops, (ItemStack)d, immutable));
            }
            blockstate.onBlockExploded(this.level, blockpos, (Explosion)this);
            this.level.func_217381_Z().func_76319_b();
        }
        for (Pair pair : drops) {
            Block.func_180635_a((World)this.level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
    }

    private void addBlockDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> drops, ItemStack stack, BlockPos pos) {
        int i = drops.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)drops.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.func_226532_a_((ItemStack)itemstack, (ItemStack)stack)) continue;
            ItemStack itemstack1 = ItemEntity.func_226533_a_((ItemStack)itemstack, (ItemStack)stack, (int)16);
            drops.set(j, (Object)Pair.of((Object)itemstack1, (Object)((BlockPos)pair.getSecond())));
            if (!stack.func_190926_b()) continue;
            return;
        }
        drops.add((Object)Pair.of((Object)stack, (Object)pos));
    }
}

